function C = tproduct(A,B,L)
% Calculates the t-product under L
% 
% C = tproduct(A,B,L)
%
% with:
% A: (n1 x l  x n3)
% B: (l  x n2 x n3)
% L: (n3 x n3)
% C: (n1 x n2 x n3)
%
% Written by 

[n1,n2,n3] = size(A);
[m1,m2,m3] = size(B);
L_inv      = inv(L);
% check inputs:
if n2 ~= m1 || n3 ~= m3
    error('Inner tensor dimensions must agree');
end

A = nmodeproduct(A,L,3);
B = nmodeproduct(B,L,3);
C = zeros(n1,m2,m3);

if n2 == 1
    A = reshape(A,[n1 n2 n3]);
end

for i = 1 : n3
    C(:,:,i) = A(:,:,i)*B(:,:,i);
end

C = nmodeproduct(C,L_inv,3);

end